/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.snmp;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.settings.network.FirewallAdmin;
import com.ibm.hwmca.base.settings.network.FirewallAdminException;
import com.ibm.hwmca.base.settings.snmp.SnmpErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.shutdown.ShutdownListener;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.shutdown.ShutdownRequest;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class Snmpd
implements Runnable,
ShutdownListener,
SnmpErrorIds {
    private static final String TRACE_MASKT = "XSNMPD T";
    private static final String TRACE_MASKF = "XSNMPD F";
    private static final String TRACE_MASKD = "XSNMPD D";
    private static final String SNMPD_CONF_FILE = "snmpd.conf";
    private static final String DATA_DIR = "data";
    private static final String SNMPD_PID_FILE = "snmpd.pid";
    private static final String TMP_DIR = "tmp";
    private static final String START_SNMPD_SCRIPT = "startSNMPD";
    private static final String STOP_SNMPD_SCRIPT = "stopSNMPD";
    private static final String SNMP_PORT = "161";
    private static ShutdownManager shutdownManager = ShutdownManager.getShutdownManager();

    public void run() {
        block10: {
            Trace.trace(TRACE_MASKT, "-> Snmpd.run()");
            try {
                BaseTower baseTower;
                File snmpdPidFile = new File(BaseFileControl.getFilePath(TMP_DIR) + SNMPD_PID_FILE);
                if (snmpdPidFile.exists()) {
                    snmpdPidFile.delete();
                }
                if ((baseTower = BaseTower.getBaseTower()).isSnmpEnabled()) {
                    File snmpdConfFile = new File(BaseFileControl.getFilePath(SNMPD_CONF_FILE) + SNMPD_CONF_FILE);
                    if (snmpdConfFile.exists()) {
                        Trace.trace(TRACE_MASKF, "Snmpd.run(): SNMP is enabled for the console and snmpd.conf exists, now starting the SNMP daemon...");
                        String[] snmpdStartCmd = new String[]{START_SNMPD_SCRIPT, BaseFileControl.getFilePath(DATA_DIR) + SNMPD_CONF_FILE, BaseFileControl.getFilePath(TMP_DIR) + SNMPD_PID_FILE, BaseFileControl.getFilePath("domainsocket"), baseTower.getSnmpAgentParameters()};
                        for (int i = 0; i < snmpdStartCmd.length; ++i) {
                            Trace.trace(TRACE_MASKD, "Snmpd.run(): snmpdStartCmd[" + i + "] = " + snmpdStartCmd[i]);
                        }
                        int rc = RootProcess.executeProgram(snmpdStartCmd);
                        Trace.trace(TRACE_MASKF, "Snmpd.run(): rc = " + rc);
                        if (rc == 0) {
                            Trace.trace(TRACE_MASKF, "Snmpd.run(): The SNMP daemon was successfully started!");
                            try {
                                FirewallAdmin.getFirewallAdmin().addRuleForAllInterfaces("0.0.0.0", "0.0.0.0", "udp", SNMP_PORT);
                            }
                            catch (FirewallAdminException e) {
                                Trace.trace(TRACE_MASKF, e);
                            }
                            shutdownManager.addShutdownListener(this);
                            break block10;
                        }
                        Trace.trace(TRACE_MASKF, "Snmpd.run(): The SNMP daemon failed to start!");
                        StringBuffer buffer = new StringBuffer();
                        for (int i = 0; i < snmpdStartCmd.length; ++i) {
                            buffer.append(snmpdStartCmd[i]);
                        }
                        String command = buffer.toString();
                        HException hexc = new HException("The SNMP daemon failed to start.");
                        Trace.trace(TRACE_MASKF, hexc);
                        FrameworkLog log = new FrameworkLog(SnmpErrorIds.LOG_INFO, 2131, hexc);
                        log.add(command);
                        log.log();
                        break block10;
                    }
                    Trace.trace(TRACE_MASKF, "Snmpd.run(): The snmpd.conf file does not exist, not starting the SNMP daemon.");
                    break block10;
                }
                Trace.trace(TRACE_MASKF, "Snmpd.run(): SNMP is not enabled for the console, not starting the SNMP daemon.");
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
                new FrameworkLog(SnmpErrorIds.LOG_INFO, 2131, exc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- Snmpd.run()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdownStarting(ShutdownRequest request, long delay) {
        block7: {
            Trace.trace(TRACE_MASKT, "Snmpd.shutdownStarting(" + request + ", " + delay + ")");
            try {
                File snmpdPidFile = new File(BaseFileControl.getFilePath(TMP_DIR) + SNMPD_PID_FILE);
                if (snmpdPidFile.exists() && snmpdPidFile.canRead()) {
                    FileReader fileReader = new FileReader(snmpdPidFile);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    String pid = bufferedReader.readLine();
                    bufferedReader.close();
                    if (pid != null) {
                        Trace.trace(TRACE_MASKD, "Snmpd.shutdownStarting(): pid = " + pid);
                        String[] snmpdStopCmd = new String[]{STOP_SNMPD_SCRIPT, pid, BaseFileControl.getFilePath(TMP_DIR) + SNMPD_PID_FILE};
                        for (int i = 0; i < snmpdStopCmd.length; ++i) {
                            Trace.trace(TRACE_MASKD, "Snmpd.shutdownStarting(): snmpdStopCmd[" + i + "] = " + snmpdStopCmd[i]);
                        }
                        int rc = RootProcess.executeProgram(snmpdStopCmd);
                        Trace.trace(TRACE_MASKF, "Snmpd.shutdownStarting(): rc = " + rc);
                        if (rc != 0) {
                            Trace.trace(TRACE_MASKF, "Snmpd.shutdownStarting(): An error occured while trying to kill the SNMP daemon process!");
                            throw new HException("The SNMP daemon failed to be stopped.");
                        }
                        Trace.trace(TRACE_MASKF, "Snmpd.shutdownStarting(): The SNMP daemon process was successfully killed!");
                        snmpdPidFile.delete();
                        shutdownManager.removeShutdownListener(this);
                        break block7;
                    } else {
                        Trace.trace(TRACE_MASKF, "Snmpd.shutdownStarting(): The pid returned from the pid file is null!");
                    }
                    break block7;
                }
                Trace.trace(TRACE_MASKF, "Snmpd.shutdownStarting(): The SNMP pid file does not exist or is not readable.");
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
                new FrameworkLog(SnmpErrorIds.LOG_INFO, 2132, exc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "Snmpd.shutdownStarting()");
    }
}

